/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.Objects;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTooltipArea;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.item.MicromissilesItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdateMicromissileSettings;
import me.desht.pneumaticcraft.common.util.EntityFilter;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public class MicromissileScreen
extends AbstractPneumaticCraftScreen {
    private static final Rect2i SELECTOR_BOUNDS = new Rect2i(12, 21, 92, 81);
    private static final int MAX_DIST = SELECTOR_BOUNDS.m_110090_();
    private static final PointXY TOP_SPEED_PT = new PointXY(46, 1);
    private static final PointXY TURN_SPEED_PT = new PointXY(1, 80);
    private static final PointXY DMG_PT = new PointXY(92, 80);
    private float turnSpeed;
    private float topSpeed;
    private float damage;
    private PointXY point;
    private MicromissilesItem.FireMode fireMode;
    private boolean dragging = false;
    private String entityFilter;
    private int sendTimer = 0;
    private final InteractionHand hand;
    private WidgetTextField textField;
    private WidgetLabel filterLabel;
    private WidgetButtonExtended modeButton;
    private WidgetButtonExtended warningButton;

    private MicromissileScreen(Component title, InteractionHand hand) {
        super(title);
        this.xSize = 183;
        this.ySize = 191;
        ItemStack stack = ClientUtils.getClientPlayer().m_21120_(hand);
        if (stack.m_41720_() == ModItems.MICROMISSILES.get() && stack.m_41782_()) {
            CompoundTag tag = Objects.requireNonNull(stack.m_41783_());
            this.topSpeed = tag.m_128457_("topSpeed");
            this.turnSpeed = tag.m_128457_("turnSpeed");
            this.damage = tag.m_128457_("damage");
            this.entityFilter = tag.m_128461_("filter");
            this.point = new PointXY(tag.m_128451_("px"), tag.m_128451_("py"));
            this.fireMode = MicromissilesItem.FireMode.fromString(tag.m_128461_("fireMode"));
            this.hand = hand;
        } else {
            this.damage = 0.33333334f;
            this.turnSpeed = 0.33333334f;
            this.topSpeed = 0.33333334f;
            this.point = new PointXY(MAX_DIST / 2, MAX_DIST / 4);
            this.entityFilter = "";
            this.fireMode = MicromissilesItem.FireMode.SMART;
            this.hand = InteractionHand.MAIN_HAND;
        }
    }

    public static void openGui(Component title, InteractionHand handIn) {
        Minecraft.m_91087_().m_91152_((Screen)new MicromissileScreen(title, handIn));
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        MutableComponent labelStr = PneumaticCraftUtils.xlate("pneumaticcraft.gui.sentryTurret.targetFilter", new Object[0]);
        this.filterLabel = new WidgetLabel(this.guiLeft + 12, this.guiTop + 130, (Component)labelStr);
        this.m_142416_((GuiEventListener)this.filterLabel);
        int textBoxX = this.guiLeft + 12 + this.f_96547_.m_92852_((FormattedText)labelStr) + 5;
        int textBoxWidth = this.xSize - (textBoxX - this.guiLeft) - 20;
        this.textField = new WidgetTextField(this.f_96547_, textBoxX, this.guiTop + 128, textBoxWidth, 10);
        this.textField.m_94144_(this.entityFilter);
        this.m_7522_((GuiEventListener)this.textField);
        this.textField.m_94178_(true);
        this.textField.m_94151_(s -> {
            this.entityFilter = s;
            if (this.validateEntityFilter(this.entityFilter)) {
                this.sendTimer = 5;
            }
        });
        this.m_142416_((GuiEventListener)this.textField);
        this.m_142416_((GuiEventListener)new WidgetTooltipArea(this.guiLeft + 42, this.guiTop + 9, 35, 9, new Component[]{PneumaticCraftUtils.xlate("pneumaticcraft.gui.micromissile.topSpeed", new Object[0])}));
        this.m_142416_((GuiEventListener)new WidgetTooltipArea(this.guiLeft + 6, this.guiTop + 103, 25, 12, new Component[]{PneumaticCraftUtils.xlate("pneumaticcraft.gui.micromissile.turnSpeed", new Object[0])}));
        this.m_142416_((GuiEventListener)new WidgetTooltipArea(this.guiLeft + 96, this.guiTop + 103, 15, 15, new Component[]{PneumaticCraftUtils.xlate("pneumaticcraft.gui.micromissile.damage", new Object[0])}));
        MutableComponent saveLabel = PneumaticCraftUtils.xlate("pneumaticcraft.gui.micromissile.saveDefault", new Object[0]);
        int buttonWidth = this.f_96547_.m_92852_((FormattedText)saveLabel) + 10;
        int buttonX = this.guiLeft + (this.xSize - buttonWidth) / 2;
        this.m_142416_((GuiEventListener)new WidgetButtonExtended(buttonX, this.guiTop + 160, buttonWidth, 20, (Component)saveLabel, b -> this.sendSettingsToServer(true)));
        this.modeButton = new WidgetButtonExtended(this.guiLeft + 123, this.guiTop + 20, 52, 20, (Component)Component.m_237119_(), b -> this.modeSwitch()).setTooltipKey("pneumaticcraft.gui.micromissile.modeTooltip", new Object[0]);
        this.m_142416_((GuiEventListener)this.modeButton);
        this.warningButton = new WidgetButtonExtended(this.guiLeft + 162, this.guiTop + 123, 20, 20);
        this.warningButton.setVisible(false);
        this.warningButton.setRenderedIcon(Textures.GUI_PROBLEMS_TEXTURE);
        this.m_142416_((GuiEventListener)this.warningButton);
        this.validateEntityFilter(this.entityFilter);
        this.setupWidgets();
    }

    private void modeSwitch() {
        int n = this.fireMode.ordinal() + 1;
        if (n >= MicromissilesItem.FireMode.values().length) {
            n = 0;
        }
        this.fireMode = MicromissilesItem.FireMode.values()[n];
        this.setupWidgets();
        this.sendSettingsToServer(false);
    }

    private void setupWidgets() {
        this.textField.m_94186_(this.fireMode == MicromissilesItem.FireMode.SMART);
        this.filterLabel.setColor(this.fireMode == MicromissilesItem.FireMode.SMART ? -12566464 : -5592406);
        this.modeButton.m_93666_((Component)PneumaticCraftUtils.xlate(this.fireMode.getTranslationKey(), new Object[0]));
    }

    @Override
    public void m_6305_(PoseStack matrixStack, int x, int y, float partialTicks) {
        this.m_7333_(matrixStack);
        super.m_6305_(matrixStack, x, y, partialTicks);
        if (ClientUtils.isKeyDown(290)) {
            GuiUtils.showPopupHelpScreen(matrixStack, this, this.f_96547_, GuiUtils.xlateAndSplit("pneumaticcraft.gui.entityFilter.helpText", new Object[0]));
        } else if (this.textField.m_198029_()) {
            String str = I18n.m_118938_((String)"pneumaticcraft.gui.entityFilter.holdF1", (Object[])new Object[0]);
            this.f_96547_.m_92883_(matrixStack, str, (float)this.guiLeft + (float)(this.xSize - this.f_96547_.m_92895_(str)) / 2.0f, (float)(this.guiTop + this.ySize + 5), 0x808080);
        }
    }

    @Override
    protected void drawForeground(PoseStack matrixStack, int x, int y, float partialTicks) {
        if (this.fireMode == MicromissilesItem.FireMode.DUMB) {
            return;
        }
        if (this.point != null) {
            float px = this.point.x();
            float py = this.point.y();
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)(this.guiLeft + SELECTOR_BOUNDS.m_110085_()), (double)(this.guiTop + SELECTOR_BOUNDS.m_110086_()), 0.0);
            int size = this.dragging ? 5 : 3;
            RenderSystem.m_69832_((float)2.0f);
            BufferBuilder wr = Tesselator.m_85913_().m_85915_();
            Matrix4f posMat = matrixStack.m_85850_().m_85861_();
            wr.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
            wr.m_85982_(posMat, px - (float)size, py, 0.0f).m_6122_(32, 32, 32, 255).m_5752_();
            wr.m_85982_(posMat, px + (float)size, py, 0.0f).m_6122_(32, 32, 32, 255).m_5752_();
            wr.m_85982_(posMat, px, py - (float)size, 0.0f).m_6122_(32, 32, 32, 255).m_5752_();
            wr.m_85982_(posMat, px, py + (float)size, 0.0f).m_6122_(32, 32, 32, 255).m_5752_();
            Tesselator.m_85913_().m_85914_();
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69832_((float)1.0f);
            wr.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
            wr.m_85982_(posMat, px, py, 0.0f).m_6122_(32, 32, 32, 128).m_5752_();
            wr.m_85982_(posMat, (float)SELECTOR_BOUNDS.m_110090_() / 2.0f, 0.0f, 0.0f).m_6122_(32, 32, 32, 128).m_5752_();
            wr.m_85982_(posMat, px, py, 0.0f).m_6122_(32, 32, 32, 128).m_5752_();
            wr.m_85982_(posMat, 0.0f, (float)SELECTOR_BOUNDS.m_110091_(), 0.0f).m_6122_(32, 32, 32, 128).m_5752_();
            wr.m_85982_(posMat, px, py, 0.0f).m_6122_(32, 32, 32, 128).m_5752_();
            wr.m_85982_(posMat, (float)SELECTOR_BOUNDS.m_110090_(), (float)SELECTOR_BOUNDS.m_110091_(), 0.0f).m_6122_(32, 32, 32, 128).m_5752_();
            Tesselator.m_85913_().m_85914_();
            RenderSystem.m_69461_();
            matrixStack.m_85849_();
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)this.guiLeft, (double)this.guiTop, 0.0);
        MicromissileScreen.m_93172_((PoseStack)matrixStack, (int)125, (int)48, (int)(125 + (int)(49.0f * this.topSpeed)), (int)54, (int)-16728064);
        MicromissileScreen.m_93172_((PoseStack)matrixStack, (int)125, (int)68, (int)(125 + (int)(49.0f * this.turnSpeed)), (int)74, (int)-16728064);
        MicromissileScreen.m_93172_((PoseStack)matrixStack, (int)125, (int)88, (int)(125 + (int)(49.0f * this.damage)), (int)94, (int)-16728064);
        matrixStack.m_85849_();
    }

    @Override
    public void m_86600_() {
        super.m_86600_();
        if (this.sendTimer > 0 && --this.sendTimer == 0) {
            this.sendSettingsToServer(false);
        }
    }

    public boolean m_7043_() {
        return false;
    }

    @Override
    protected ResourceLocation getTexture() {
        return Textures.GUI_MICROMISSILE;
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (this.trySetPoint((int)mouseX, (int)mouseY)) {
            this.dragging = true;
            return true;
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public boolean m_6348_(double mouseX, double mouseY, int mouseButton) {
        if (this.dragging) {
            this.sendSettingsToServer(false);
            this.dragging = false;
            return true;
        }
        return super.m_6348_(mouseX, mouseY, mouseButton);
    }

    public boolean m_7979_(double mouseX, double mouseY, int mouseButton, double dx, double dy) {
        if (this.dragging) {
            this.trySetPoint((int)mouseX, (int)mouseY);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, mouseButton, dx, dy);
    }

    private boolean validateEntityFilter(String filter) {
        try {
            this.warningButton.f_93624_ = false;
            this.warningButton.setTooltipText((Component)Component.m_237119_());
            new EntityFilter(filter);
            return true;
        }
        catch (Exception e) {
            this.warningButton.f_93624_ = true;
            this.warningButton.setTooltipText((Component)Component.m_237113_((String)e.getMessage()).m_130940_(ChatFormatting.GOLD));
            return false;
        }
    }

    private boolean trySetPoint(int mouseX, int mouseY) {
        PointXY p = this.getPoint(mouseX, mouseY);
        if (p != null) {
            double dSpeed = (double)MAX_DIST - p.distance(TOP_SPEED_PT);
            double dTurnSpd = (double)MAX_DIST - p.distance(TURN_SPEED_PT);
            double dDamage = (double)MAX_DIST - p.distance(DMG_PT);
            double total = dSpeed + dTurnSpd + dDamage;
            this.topSpeed = (float)(dSpeed / total);
            this.turnSpeed = (float)(dTurnSpd / total);
            this.damage = (float)(dDamage / total);
            this.point = p;
            return true;
        }
        return false;
    }

    private void sendSettingsToServer(boolean saveDefault) {
        NetworkHandler.sendToServer(new PacketUpdateMicromissileSettings(this.topSpeed, this.turnSpeed, this.damage, this.point, this.entityFilter, this.fireMode, saveDefault, this.hand));
    }

    private PointXY getPoint(int mouseX, int mouseY) {
        Rect2i r = new Rect2i(SELECTOR_BOUNDS.m_110085_() + this.guiLeft, SELECTOR_BOUNDS.m_110086_() + this.guiTop, SELECTOR_BOUNDS.m_110090_(), SELECTOR_BOUNDS.m_110091_());
        if (!r.m_110087_(mouseX, mouseY)) {
            return null;
        }
        PointXY p = new PointXY(mouseX - r.m_110085_(), mouseY - r.m_110086_());
        return this.isPointInTriangle(p, TOP_SPEED_PT, TURN_SPEED_PT, DMG_PT) ? p : null;
    }

    private boolean isPointInTriangle(PointXY s, PointXY a, PointXY b, PointXY c) {
        int as_x = s.x() - a.x();
        int as_y = s.y() - a.y();
        boolean s_ab = (b.x() - a.x()) * as_y - (b.y() - a.y()) * as_x > 0;
        if ((c.x() - a.x()) * as_y - (c.y() - a.y()) * as_x > 0 == s_ab) {
            return false;
        }
        return (c.x() - b.x()) * (s.y() - b.y()) - (c.y() - b.y()) * (s.x() - b.x()) > 0 == s_ab;
    }
}

